#!/usr/bin/env python
# Sort Using Related Report
# Copyright 2004 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 041130 - first version of this script, based on Sort By Priority
# 041229 - combine three scripts into this one (based on Alex's suggestion)
#	Includes: Remember Sequence, Forget Sequence, and Sort By Remembered Sequence

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

def SortOnSequence(self):
    rid = self.ReportID  # current report
    trep = Data.Database['Report']
    trow = Data.Database['ReportRow']
    ttyp = Data.Database['ReportType']
    tid = trep[rid].get('ReportTypeID')
    if not tid: return  # all reports must have a type

    # make a list of related reports

    tablea = ttyp[tid].get('TableA')
    if not tablea: return
    projid = trep[rid].get('ProjectID')
    if not projid: return

    menuid = []  # list of types to be displayed for selection
    for k, v in trep.iteritems():
        if debug: print "k", k
        if v.get('zzStatus') == 'deleted' or v.get('ProjectID') != projid or k == rid: continue
        if debug: print "active & same project"
        typeid = v.get('ReportTypeID')
        if not typeid or not ttyp.has_key(typeid): continue
        if debug: print "has type"
        if not tablea == ttyp[typeid].get('TableA'): continue
        if debug: print "has same primary table"
        menuid.append( k )

    if not menuid: 
        hint("Couldn't find related report (with same first table)")
        return
    if len(menuid) == 1:
        choice = menuid[0]
    else:
        menutext = [ (trep[x].get('Label') or trep[x].get('Name')) for x in menuid ]
        if debug: print menuid, menutext
        dlg = wx.SingleChoiceDialog(self, "Select report to match:", "Sort Report", menutext)
        if (dlg.ShowModal() != wx.ID_OK): return
        selection = dlg.GetSelection()
        choice = menuid[selection]

    seqcol = "Seq_" + tablea

    # forget order value for this report (only if two table report)
    # old sequence data can mess up order of second table records
    if ttyp[tid].get('TableB'):
        rlist = Data.GetRowList(rid)
 
        for i, id in enumerate(rlist):
            rr = trow[id]
            tn, tid = rr.get('TableName'), rr.get('TableID')
            if tn and tid and Data.Database[tn][tid].get(seqcol) != None:
                change = { 'Table': tn, 'ID': tid, seqcol: None}
                Data.Update(change)

    # remember sequence of target report
    ctid = trep[choice].get('ReportTypeID')
    if not ctid: return  # all reports must have a type

    rlist = Data.GetRowList(choice)
    if len(rlist) < 2 : return  # don't remember if no rows or one row

    for i, id in enumerate(rlist):
        rr = trow[id]
        tn, tid = rr.get('TableName'), rr.get('TableID')
        if tn and tid and Data.Database[tn][tid].get(seqcol) != i:
            change = { 'Table': tn, 'ID': tid, seqcol: i}
            Data.Update(change)

    # sort on remembered sequence
    rlist = Data.GetRowList(rid)
    if len(rlist) < 2 : return  # don't sort if no rows or one row

    seq = {}  # capture current sequence
    for i, id in enumerate(rlist):
        seq[id] = i

    def mycmp(a, b):
        def sortval(a):
            rr = trow[a]
            tn, tid = rr.get('TableName'), rr.get('TableID')
            if tn and tid:
                if tn == tablea: # parent row?
                    val1 = Data.Database[tn][tid].get(seqcol)
                    val2 = None
                else:
                    parentid = Data.Database[tn][tid].get(tablea + "ID")
                    if parentid:
                        val1 = Data.Database[tablea][parentid].get(seqcol)
                    else:
                        val1 = None
                    val2 = Data.Database[tn][tid].get(seqcol)
            else:
                val1, val2 = None, None
            return (val1, val2, seq[a])

        return cmp(sortval(a), sortval(b))

    rlist.sort(mycmp)
    Data.ReorderReportRows(rid, rlist)
    Data.SetUndo("Sort Like Related Report")

SortOnSequence(self)
